﻿using Microsoft.SharePoint;

namespace BreakRoleInheritance
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb())
            {
               // Zugriff auf die Dokumentbibliothek
               SPDocumentLibrary docLib =
                  web.Lists.TryGetList("Dokumente")
                  as SPDocumentLibrary;

               // Hole die Gruppe Leser und erstelle ein SPRoleAssignment-Objekt
               SPGroup groupReader = web.Groups["Besucher von Blank"];
               SPRoleAssignment roleAssignmentReader =
                  new SPRoleAssignment(groupReader);

               // Rollendefinition für das Lesen-Recht erzeugen
               SPRoleDefinition roleDefRead =
                  web.RoleDefinitions["Lesen"];
               roleAssignmentReader.RoleDefinitionBindings
                  .Add(roleDefRead);

               // Berechtigungsvererbung aufbrechen
               // Rollenzuweisungen nicht kopieren
               docLib.BreakRoleInheritance(false);

               // Rollenzuweisung für die SharePoint-Gruppe hinzufügen
               docLib.RoleAssignments.Add(roleAssignmentReader);
               docLib.Update();
            }
         }
      }
   }
}